﻿#nullable enable
namespace Hims.Api.Models.Account
{
    using System.Collections.Generic;
    using Shared.Library.Enums;

    /// <summary>
    /// The forgot password request.
    /// </summary>
    public class ForgotPasswordRequest
    {
        /// <summary>
        /// Gets or sets the account id.
        /// </summary>
        public int AccountId { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Username { get; set; } = string.Empty;

        /// <summary>
        /// Gets or sets the password.
        /// </summary>
        public string? Password { get; set; }

        /// <summary>
        /// Gets or sets the role Id.
        /// </summary>
        public int? RoleId { get; set; }

        /// <summary>
        /// Gets or sets the mobile.
        /// </summary>
        public string Mobile { get; set; }
        /// <summary>
        /// Gets or sets the account types.
        /// </summary>
        public IEnumerable<AccountType> AccountTypes { get; set; } = new List<AccountType>();
    }
}
